# **Line of Control \- CTF Walkthrough**

This challenge puts you in the role of a SERPENT agent working with Indian intelligence. War has broken out between Pakistan and India, and you've intercepted Pakistani plans for an imminent attack on Indian air bases. Your mission is to analyze the materials, identify the targets, commander, and the timing of the planned attack.

## **The Scenario**

You've been briefed that:

* War has broken out between India and Pakistan  
* India has reached out to SERPENT for intelligence assistance  
* Pakistani attack plans have been intercepted  
* You need to identify the attack locations, date/time, and commanding officer

## **Analyzing the Evidence**

The materials contain several critical pieces of information:

### **1\. The Targets**

The documents contain information about three Indian Air Force bases:

**Target 1:** Jaisalmer Airport

* Location: Air Force School Rd, Shastri Nagar, Jaisalmer, Rajasthan 345001, India  
* Google Maps coordinates provided

**Target 2:** Sri Guru Ram Dass Jee International Airport, Amritsar

* Located in Amritsar  
* Google Maps coordinates provided

**Target 3:** Air Force Station Naliya

* Location: Naliya abdasa, Bhanada, Gujarat 370655, India  
* Google Maps coordinates provided

### **2\. The Commander and Attack Timing**

The briefing to the Pakistani commander is written in Urdu (though translated in the materials), and mentions:

* **Commander's Name:** Air Marshall Imran Hameed  
* **Attack Date/Time:** "Next Tuesday at twenty-zero-zero hours" (2000 hours, or 8:00 PM)

### **3\. Other Intelligence**

Additional information revealed:

* The objective is to destroy valuable Indian Air Force assets  
* The operation must be swift and decisive  
* Complete media silence is required  
* Various satellite images and documents about Indian Air Force capabilities were provided to the Pakistani commanders

## **Formulating the Answer**

Based on the challenge instructions, we need to provide the answer in a specific format:

* Cities where the airbases are located, in order  
* Time of attack  
* Commander's name

The cities in order are:

1. Jaisalmer  
2. Amritsar  
3. Naliya

The attack time is 2000 hours (8:00 PM)

The commander is Air Marshall Imran Hameed

## **The Final Answer**

According to the format given in the example (cities-day-time-commander), the answer would be:

```
jaisalmer-amritsar-naliya-tuesday-2000-imran-hameed
```

## **Solution Steps Summary**

1. Identified three target locations from the materials:

   * Jaisalmer Airport  
   * Sri Guru Ram Dass Jee International Airport (Amritsar)  
   * Air Force Station Naliya  
2. Located the commander's name in the Urdu briefing translation:

   * Air Marshall Imran Hameed  
3. Found the attack timing in the same briefing:

   * Next Tuesday at 2000 hours (8:00 PM)  
4. Formatted the answer according to requirements:

   * jaisalmer-amritsar-naliya-tuesday-2000-imran-hameed
